using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class XmlSolidHue : XmlAttachment
	{
		private int m_Hue;
        
		[CommandProperty( AccessLevel.GameMaster )]
		public int Hue { get{ return m_Hue; } set { m_Hue = value; } }

		// These are the various ways in which the message attachment can be constructed.  
		// These can be called via the [addatt interface, via scripts, via the spawner ATTACH keyword.
		// Other overloads could be defined to handle other types of arguments
       
		// a serial constructor is REQUIRED
		public XmlSolidHue(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public XmlSolidHue(int value)
		{
			m_Hue = value;
			Expiration = TimeSpan.FromMinutes( 60.0 );    // default 60 minutes duration
		}
        
		[Attachable]
		public XmlSolidHue(int value, double duration)
		{
			m_Hue = value;
			Expiration = TimeSpan.FromMinutes(duration);
		}
        
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);
			writer.Write( (int) 0 );
			// version 0
			writer.Write(m_Hue);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
			// version 0

			m_Hue = reader.ReadInt();
		}
		
		public override string OnIdentify(Mobile from)
		{
			base.OnIdentify(from);

			if(from == null || from.AccessLevel == AccessLevel.Player) return null;

			if(Expiration > TimeSpan.Zero)
			{
				return String.Format("Solid Hue Override {0} expires in {1} mins",m_Hue,Expiration.TotalMinutes);
			} 
			else
			{
				return String.Format("Solid Hue Override {0}",m_Hue);
			}
		}

		public override void OnDelete()
		{
			base.OnDelete();
			// remove the mod
			if(AttachedTo is Mobile)
			{
				((Mobile)AttachedTo).SolidHueOverride = -1;
			} 
		}

		public override void OnAttach()
		{
			base.OnAttach();

			// apply the mod
			if( AttachedTo is Mobile )
				((Mobile)AttachedTo).SolidHueOverride = m_Hue;
			else
				Delete();
		}

	}
}
